<?php
class ControllerExtensionModulePaytrTaksitTab extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/module/paytr_taksit_tab');
		$this->load->model('setting/setting');

		$this->document->setTitle($this->language->get('heading_title'));

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('paytr_taksit', $this->request->post);
			$this->session->data['success'] = $this->language->get('text_success');
			$this->response->redirect($this->url->link('extension/module/paytr_taksit_tab', 'user_token=' . $this->session->data['user_token'] . '&type=module', true));
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');

		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_listing_status'] = $this->language->get('entry_listing_status');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('extension/module', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/module/paytr_taksit_tab', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['action'] = $this->url->link('extension/module/paytr_taksit_tab', 'user_token=' . $this->session->data['user_token'], true);

		$data['cancel'] = $this->url->link('extension/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);

		if (isset($this->request->post['paytr_taksit_status'])) {
			$data['paytr_taksit_status'] = $this->request->post['paytr_taksit_status'];
		} else {
			$data['paytr_taksit_status'] = $this->config->get('paytr_taksit_status');
		}
		if (isset($this->request->post['paytr_taksit_text'])) {
			$data['paytr_taksit_text'] = $this->request->post['paytr_taksit_text'];
		} else {
			$data['paytr_taksit_text'] = $this->config->get('paytr_taksit_text');
		}
		if (isset($this->request->post['paytr_taksit_token_text'])) {
			$data['paytr_taksit_token_text'] = $this->request->post['paytr_taksit_token_text'];
		} else {
			$data['paytr_taksit_token_text'] = $this->config->get('paytr_taksit_token_text');
		}
		if (isset($this->request->post['paytr_taksit_merchantid_text'])) {
			$data['paytr_taksit_merchantid_text'] = $this->request->post['paytr_taksit_merchantid_text'];
		} else {
			$data['paytr_taksit_merchantid_text'] = $this->config->get('paytr_taksit_merchantid_text');
		}
		if (isset($this->request->post['paytr_taksit_aciklama_text'])) {
			$data['paytr_taksit_aciklama_text'] = $this->request->post['paytr_taksit_aciklama_text'];
		} else {
			$data['paytr_taksit_aciklama_text'] = $this->config->get('paytr_taksit_aciklama_text');
		}
		if (isset($this->request->post['paytr_taksit_alt_text'])) {
			$data['paytr_taksit_alt_text'] = $this->request->post['paytr_taksit_alt_text'];
		} else {
			$data['paytr_taksit_alt_text'] = $this->config->get('paytr_taksit_alt_text');
		}
		if (isset($this->request->post['paytr_taksit_sayisi_text'])) {
			$data['paytr_taksit_sayisi_text'] = $this->request->post['paytr_taksit_sayisi_text'];
		} else {
			$data['paytr_taksit_sayisi_text'] = $this->config->get('paytr_taksit_sayisi_text');
		}
		if (isset($this->request->post['paytr_taksit_kampanya'])) {
			$data['paytr_taksit_kampanya'] = $this->request->post['paytr_taksit_kampanya'];
		} else {
			$data['paytr_taksit_kampanya'] = $this->config->get('paytr_taksit_kampanya');
		}
		if (isset($this->request->post['paytr_taksit_version'])) {
			$data['paytr_taksit_version'] = $this->request->post['paytr_taksit_version'];
		} else {
			$data['paytr_taksit_version'] = $this->config->get('paytr_taksit_version');
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/module/paytr_taksit_tab', $data));
	}
	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/module/paytr_taksit_tab')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		if($this->request->post['paytr_taksit_status'] == 1){
			if($this->request->post['paytr_taksit_text'] == '' || $this->request->post['paytr_taksit_token_text'] == '' || $this->request->post['paytr_taksit_merchantid_text'] == '' || $this->request->post['paytr_taksit_sayisi_text'] == '' || $this->request->post['paytr_taksit_version'] == '' || $this->request->post['paytr_taksit_kampanya'] == ''){
				$this->error['warning'] = 'Üst ve Alt yazı alanları dışındaki tüm alanları doldurmak zorundasınız!';
			}
		}
		if($this->request->post['paytr_taksit_version'] != 1 && $this->request->post['paytr_taksit_version'] != 2){
				$this->error['warning'] = 'Taksit Tablosu Version olarak yalnızca 1 veya 2 girin!';
			}
		return !$this->error;
	}
}